; magWord.jss
include "hjglobal.jsh"
Include "hjconst.jsh" ; constants for attributes, window classes
Include "magic.jsh"


Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;  This function first tests for the existance of MAGic.  If MAGic is running, it then determines
;  the current window type.  If the current window type is an edit Window, it calls
;  SetMagicFocusArea to set the focus to a region surrounding the cursor position.
;  Test to determine if there is an application specific setting in the jcf file to disable the JFW tracking engine.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Var Int bSuccess
If (DidControlChange () == 1) then Return EndIf
If (GetCursorCol () - nX == 1) then Let nX = nX + 1 EndIf
If (GetWindowClass (GetCurrentWindow ()) == mWN_Winword1 || GetWindowClass (GetCurrentWindow ()) == mWN_Winword2) then
  If (IsKeyWaiting ()) then Return EndIf
  Let bSuccess = TrackEditWindow (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, GetWindowSubtypeCode (GetCurrentWindow ()), GetWindowClass (GetCurrentWindow ()), GetAppMainWindow (GetFocus ()))
  If (bSuccess == 1) then Return Else MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed) Return EndIf
Else
  MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed)
EndIf
EndFunction

Int Function DidControlChange ()
Var Handle prevWinHandle, Int nX, Int nY, Int pwTop, Int pwLeft, String pwButtonLabel
If (!MagGetState () > 0) then Return EndIf
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
Let prevWinHandle = cwHandle
Let cwHandle = GetWindowAtPoint (nX, nY)
Let pwLeft = cwLeft  Let pwTop = cwTop
Let cwTop = GetWindowTop (GetCurrentWindow ())
Let cwLeft = GetWindowLeft (GetCurrentWindow ())
Let pwButtonLabel = cwButtonLabel
Let cwButtonLabel = GetWord ()
If ((GetWindowSubtypeCode (GetRealWindow (GetFocus ())) == WT_DIALOG)
    || (DialogActive () == ACTIVE)) then
    If (cwTop != pwTop || cwLeft != pwLeft) then Return 1
    ElIf (GetWindowSubtypeCode (GetCurrentWindow ()) == WT_BUTTON) then
      If (cwButtonLabel != pwButtonLabel) then Return 1 EndIf
    ElIf (cwHandle != prevWinHandle) then Return 1 EndIf
Else Return 0 EndIf
EndFunction

